#include <stdio.h>
#include <stdlib.h>

#define MAXN 200000

typedef long long ll;

/* ---------- Fenwick ---------- */

ll bit_cnt[MAXN + 5];
ll bit_sum[MAXN + 5];
int SZ;

void bit_add(ll *bit, int i, ll v) {
    for (; i <= SZ; i += i & -i)
        bit[i] += v;
}

ll bit_sumq(ll *bit, int i) {
    ll s = 0;
    for (; i > 0; i -= i & -i)
        s += bit[i];
    return s;
}

/* ---------- main ---------- */

int N, Q;
int a[MAXN + 1];
ll cnt[MAXN + 1];
ll W[MAXN + 1];
ll vals[MAXN + 1];

int cmp(const void *a, const void *b) {
    ll x = *(ll *)a, y = *(ll *)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

int idx(ll x) {
    int l = 1, r = SZ, m;
    while (l <= r) {
        m = (l + r) >> 1;
        if (vals[m] == x) return m;
        if (vals[m] < x) l = m + 1;
        else r = m - 1;
    }
    return -1;
}

ll query_top(ll t) {
    if (t <= 0) return 0;
    if (t >= bit_sumq(bit_cnt, SZ))
        return bit_sumq(bit_sum, SZ);

    int pos = 0;
    ll need = t;
    for (int i = 1 << 18; i; i >>= 1) {
        if (pos + i <= SZ && bit_cnt[pos + i] < need) {
            need -= bit_cnt[pos + i];
            pos += i;
        }
    }

    ll res = bit_sumq(bit_sum, SZ) - bit_sumq(bit_sum, pos);
    ll extra = need * vals[pos + 1];
    return res - extra;
}

int main() {
    scanf("%d %d", &N, &Q);

    for (int i = 1; i <= N; i++) {
        scanf("%d", &a[i]);
        cnt[a[i]]++;
    }

    int vc = 0;
    for (int v = 1; v <= N; v++) {
        if (cnt[v]) {
            W[v] = cnt[v] * v;
            vals[++vc] = W[v];
        }
    }

    qsort(vals + 1, vc, sizeof(ll), cmp);
    SZ = 0;
    for (int i = 1; i <= vc; i++)
        if (i == 1 || vals[i] != vals[i - 1])
            vals[++SZ] = vals[i];

    ll total = 0;
    for (int v = 1; v <= N; v++) {
        if (cnt[v]) {
            int p = idx(W[v]);
            bit_add(bit_cnt, p, 1);
            bit_add(bit_sum, p, W[v]);
            total += W[v];
        }
    }

    while (Q--) {
        int t;
        scanf("%d", &t);

        if (t == 1) {
            int k;
            scanf("%d", &k);
            ll rem = query_top(N - k);
            ll ans = total - rem;
            printf("%lld\n", ans);
        } else {
            int x, y;
            scanf("%d %d", &x, &y);
            int old = a[x];
            if (old == y) continue;

            int p = idx(W[old]);
            bit_add(bit_cnt, p, -1);
            bit_add(bit_sum, p, -W[old]);
            total -= W[old];

            cnt[old]--;
            if (cnt[old]) {
                W[old] = cnt[old] * old;
                p = idx(W[old]);
                bit_add(bit_cnt, p, 1);
                bit_add(bit_sum, p, W[old]);
                total += W[old];
            }

            cnt[y]++;
            if (cnt[y] == 1) {
                W[y] = y;
            } else {
                int p2 = idx(W[y]);
                bit_add(bit_cnt, p2, -1);
                bit_add(bit_sum, p2, -W[y]);
                total -= W[y];
                W[y] += y;
            }

            int p3 = idx(W[y]);
            bit_add(bit_cnt, p3, 1);
            bit_add(bit_sum, p3, W[y]);
            total += W[y];

            a[x] = y;
        }
    }

    return 0;
}